---
# ═══════════════════════════════════════════════════════════════════════════════
# ArchonDev Governance Template
# Powered by ArchonDev - AI Development Governance by Jumping Ahead Corp.
# ═══════════════════════════════════════════════════════════════════════════════
#
# This file is your project's "constitution" - it defines boundaries, rules,
# and quality gates that AI assistants and developers must follow.
#
# HOW TO CUSTOMIZE:
# 1. Update the components section to match YOUR project structure
# 2. Add invariants that enforce YOUR coding standards
# 3. Define protected paths for YOUR critical files
# 4. Adjust quality gates for YOUR deployment environments
#
# The YAML frontmatter below is machine-readable. The Markdown body is for
# human documentation. Both are version-controlled with your code.
# ═══════════════════════════════════════════════════════════════════════════════

version: "1.0"
updatedAt: "2026-01-19"
profile: "balanced"           # Options: strict, balanced, permissive
strictMode: false             # Set true to treat all warnings as errors

# ─────────────────────────────────────────────────────────────────────────────
# SYSTEM GOALS
# Define what your project is trying to achieve at a high level.
# AI assistants will consider these when making implementation decisions.
# ─────────────────────────────────────────────────────────────────────────────
systemGoals:
  - id: "GOAL-001"
    title: "Example: Maintain clean architecture"
    description: "Keep layers separated with clear boundaries between UI, business logic, and data"
    priority: "HIGH"          # CRITICAL, HIGH, MEDIUM, LOW

  - id: "GOAL-002"
    title: "Example: Security first"
    description: "Never expose credentials, validate all inputs, sanitize all outputs"
    priority: "CRITICAL"

# ─────────────────────────────────────────────────────────────────────────────
# COMPONENTS & BOUNDARIES
# Define the major parts of your system and how they relate.
#
# boundary options:
#   - PUBLIC_API: External interface, changes require versioning consideration
#   - INTERNAL: Used within the system only
#   - INFRASTRUCTURE: Database, caching, external services
#
# stability options:
#   - STABLE: Rarely changes, other code depends on it
#   - EVOLVING: Active development, expect changes
#   - EXPERIMENTAL: May be removed or completely rewritten
#
# coupling options for dependencies:
#   - TIGHT: Direct imports allowed, shared types
#   - LOOSE: Through interfaces/abstractions only
# ─────────────────────────────────────────────────────────────────────────────
components:
  - id: "cli"
    name: "CLI Layer"
    description: "Command-line interface for users"
    paths:
      - "src/cli/**"
    boundary: "PUBLIC_API"
    stability: "EVOLVING"
    owner: "your-team"        # Who owns this component
    dependsOn:
      - component: "core"
        coupling: "LOOSE"     # CLI should use abstractions, not internals

  - id: "core"
    name: "Core Business Logic"
    description: "Domain logic independent of UI or infrastructure"
    paths:
      - "src/core/**"
    boundary: "INTERNAL"
    stability: "STABLE"
    owner: "your-team"

  - id: "api"
    name: "API Layer"
    description: "REST/GraphQL endpoints"
    paths:
      - "src/api/**"
    boundary: "PUBLIC_API"
    stability: "EVOLVING"
    owner: "your-team"
    dependsOn:
      - component: "core"
        coupling: "TIGHT"
      - component: "db"
        coupling: "LOOSE"

  - id: "db"
    name: "Database Layer"
    description: "Data access and persistence"
    paths:
      - "src/db/**"
      - "migrations/**"
    boundary: "INFRASTRUCTURE"
    stability: "STABLE"
    owner: "your-team"

# ─────────────────────────────────────────────────────────────────────────────
# INVARIANTS (The Laws)
# Rules that must NEVER be violated. AI assistants will refuse to write code
# that breaks these rules.
#
# severity options:
#   - BLOCKING: Code will not be accepted if this is violated
#   - WARN: Warning issued but code can proceed
#
# scope: Which component(s) this applies to (* for all)
# match: Optional regex pattern to detect violations
# exception: Paths excluded from this rule
# ─────────────────────────────────────────────────────────────────────────────
invariants:
  # Example: Enforce layer separation
  - id: "INV-001"
    severity: "BLOCKING"
    rule: "CLI must not directly import database clients"
    match: "import.*from.*(pg|mysql|mongodb|prisma).*"
    scope: "cli"
    reason: "CLI should use service abstractions, not raw database access"

  # Example: Security invariant
  - id: "SEC-001"
    severity: "BLOCKING"
    rule: "Never log secrets or credentials"
    match: "(console\\.log|logger).*([Kk]ey|[Tt]oken|[Ss]ecret|[Pp]assword)"
    scope: "*"
    reason: "Prevent credential leakage in logs"

  # Example: Code quality guideline (warning, not blocking)
  - id: "INV-002"
    severity: "WARN"
    rule: "Prefer explicit error handling over try/catch swallowing"
    scope: "core"
    reason: "Errors should be handled explicitly, not silently caught"

  # Example: API consistency
  - id: "INV-003"
    severity: "BLOCKING"
    rule: "All API endpoints must use the response wrapper"
    match: "res\\.json\\((?!apiResponse)"
    scope: "api"
    exception: "src/api/health.ts"
    reason: "Consistent API response format for clients"

# ─────────────────────────────────────────────────────────────────────────────
# PROTECTED PATHS
# Critical files that require explicit approval before modification.
#
# level options:
#   - HARD: Requires explicit approval, AI will not modify without confirmation
#   - SOFT: Warning issued, but modification allowed
#
# approvalRequired: Who must approve (human, architect, security-team, etc.)
# ─────────────────────────────────────────────────────────────────────────────
protectedPaths:
  - pattern: "ARCHITECTURE.md"
    level: "HARD"
    reason: "Governance constitution - changes affect all development"
    approvalRequired: "human"

  - pattern: "src/db/schema.*"
    level: "HARD"
    reason: "Database schema changes require migration planning"
    approvalRequired: "architect"

  - pattern: "package.json"
    level: "SOFT"
    reason: "Dependency changes should be reviewed for security"

  - pattern: ".env*"
    level: "HARD"
    reason: "Environment files may contain secrets"
    approvalRequired: "human"

# ─────────────────────────────────────────────────────────────────────────────
# CAUTIOUS PATHS
# Files that warrant extra care but don't require formal approval.
# AI assistants will proceed more carefully when modifying these.
# ─────────────────────────────────────────────────────────────────────────────
cautiousPaths:
  - pattern: "src/auth/**"
    level: "SOFT"
    reason: "Authentication code is security-sensitive"

  - pattern: "migrations/**"
    level: "SOFT"
    reason: "Database migrations are often irreversible"

# ─────────────────────────────────────────────────────────────────────────────
# QUALITY GATES PER ENVIRONMENT
# Define what checks must pass before code is accepted in each environment.
#
# Gate types:
#   - ARCHITECTURE: Validates against this file's rules
#   - SYNTAX: Parses without errors
#   - LINT: Passes linter (ESLint, etc.)
#   - UNIT: Unit tests pass
#   - INTEGRATION: Integration tests pass
#   - E2E: End-to-end tests pass
#   - ACCEPTANCE: Business acceptance criteria met
#   - REVIEW: Human code review required
# ─────────────────────────────────────────────────────────────────────────────
environments:
  development:
    autoApprove: true         # Auto-approve if gates pass
    qualityGates:
      - ARCHITECTURE
      - SYNTAX
      - UNIT

  staging:
    autoApprove: false        # Requires explicit approval
    qualityGates:
      - ARCHITECTURE
      - SYNTAX
      - LINT
      - UNIT
      - INTEGRATION

  production:
    autoApprove: false
    requiresManualPromotion: true
    qualityGates:
      - ARCHITECTURE
      - SYNTAX
      - LINT
      - UNIT
      - INTEGRATION
      - ACCEPTANCE
      - E2E
      - ACCESSIBILITY    # WCAG 2.2 AA compliance check

# ─────────────────────────────────────────────────────────────────────────────
# ACCESSIBILITY REQUIREMENTS
# Required for any web-facing deployment. Non-compliance may result in
# legal liability under ADA, EAA, Section 508, or AODA.
# ─────────────────────────────────────────────────────────────────────────────
accessibility:
  standard: "WCAG 2.2 AA"
  enforceOnDeploy: true        # Block deployment if checks fail
  showLegalWarning: true       # Display liability warning
  addBadgeOnPass: true         # Add compliance badge to footer
  checks:
    - colorContrast: true      # 4.5:1 for normal text, 3:1 for large
    - altText: true            # All images must have alt text
    - keyboardNav: true        # All elements keyboard accessible
    - focusIndicators: true    # Visible focus on interactive elements
    - formLabels: true         # All inputs have labels
    - headingHierarchy: true   # Proper h1→h2→h3 structure
    - ariaRoles: true          # Correct ARIA usage

---

# ArchonDev Governance Template

## Overview

This ARCHITECTURE.md file serves as your project's governance constitution. It defines:

- **Components & Boundaries** - The structure of your system
- **Invariants** - Rules that must never be broken
- **Protected Paths** - Critical files requiring approval
- **Quality Gates** - Checks required for each environment

## The Golden Rule

> **Architecture is the input. Code is the output.**
>
> This file tells AI assistants and developers what they CAN and CANNOT do.
> Code never dictates architecture - architecture dictates code.

## How AI Assistants Use This File

When an AI assistant (Cursor, Amp, Copilot, etc.) works on your codebase:

1. It reads this ARCHITECTURE.md first
2. It respects component boundaries when making changes
3. It refuses to violate BLOCKING invariants
4. It asks for approval before modifying protected paths
5. It ensures quality gates pass before completing

## Customizing This Template

1. **Components**: Map to YOUR project's folder structure
2. **Invariants**: Add YOUR coding standards and security rules
3. **Protected Paths**: Identify YOUR critical files
4. **Quality Gates**: Match YOUR CI/CD pipeline

## Need More?

This is the **Light Package** - governance files you can use with any AI IDE.

For the complete ArchonDev experience with CLI tools, team management,
and token usage tracking:

```bash
npm install -g archon
```

---

**Full documentation:** [https://ArchonDev.io](https://ArchonDev.io)

*Powered by ArchonDev - AI Development Governance by Jumping Ahead Corp.*
