# Powered by ArchonDev - AI Development Governance

**Read this file and ARCHITECTURE.md on every session start.**

---

## 🚀 First-Run Detection

**Check progress.txt first.** Then determine which scenario applies:

| Condition | Scenario | Action |
|-----------|----------|--------|
| No progress.txt entries + no source files | **New project** | See `archondev-scenarios/new-project-interview.md` |
| No progress.txt entries + existing source files | **Adapting existing** | See `archondev-scenarios/adapt-existing-project.md` |
| Has progress.txt entries | **Continuing** | See `archondev-scenarios/continue-session.md` |

**Trigger phrases:**
- `archon walkthrough` — restart onboarding
- `archon adapt` — adapt to existing project
- `archon status` — show project state

---

## Core Rules (Always Apply)

### The Golden Rule
> **Architecture is the input. Code is the output.**

### Before Any Code Change
1. Parse `ARCHITECTURE.md` for boundaries and invariants
2. Check `DEPENDENCIES.md` for downstream impacts
3. Respect protected paths (ask before modifying)

### After Completing Work
1. Run quality gates (build, test, lint)
2. Append to `progress.txt`
3. Consider handoff if context is getting full

---

## Quick Reference

| Command | Action |
|---------|--------|
| `review this file` | Code review mode (no modifications) |
| `memory check` | Report context usage |
| `save handoff` | Create handoff entry for next session |
| `initialize archon database` | Create local SQLite for atom tracking |
| `plan these tasks` | Extract and confirm multi-item requests |
| `task status` | Show current task list progress |

---

## 📋 Task Extraction Protocol

When user describes work with **multiple items**:

1. **Extract & number** all items from the request
2. **Present checklist** for user confirmation
3. **Lock the list** in `.archon/current-tasks.md`
4. **Work systematically** — complete and check off each item
5. **Verify all items** before declaring done

**See:** `archondev-scenarios/task-extraction.md` for full protocol

**Trigger phrases:**
- `plan these tasks` — force extraction mode
- `what's on my list` — show active tasks
- `task status` — show progress

---

## Key Files

| File | Purpose |
|------|---------|
| `ARCHITECTURE.md` | Rules and boundaries (source of truth) |
| `AGENTS.md` | This file — AI instructions |
| `DEPENDENCIES.md` | File-level dependency tracking |
| `progress.txt` | Append-only learning log |
| `archondev-scenarios/` | Detailed prompts for each scenario |
| `.archon/current-tasks.md` | Active task list (when working multi-item requests) |

---

## 🔍 Code Review Mode

When user says "review this file" or "code review":

1. **Check for:** Architecture violations, security issues, code quality, missing docs
2. **Output format:** Summary → Critical/Warning/Info issues → Recommendations
3. **Important:** ONLY analyze. Do NOT modify files.

---

## 🧠 Memory Management

- **At ~60% context:** Warn user, suggest saving progress
- **At ~80% context:** Initiate handoff (save state to progress.txt)
- **Commands:** `memory check`, `save progress`, `prepare handoff`

---

## ♿ Pre-Deploy Accessibility Check

**IMPORTANT:** Before deploying any live website, run accessibility audit.

When user says "deploy", "go live", "publish", or "launch":

1. **Announce** accessibility check is required
2. **Run checklist** (contrast, keyboard nav, alt text, forms, structure)
3. **Report issues** with WCAG criteria and severity
4. **Warn about legal liability** (ADA, EAA, Section 508)
5. **Offer options:** Fix now / Deploy anyway / Cancel

**See:** `archondev-scenarios/pre-deploy-accessibility.md` for full protocol

**Trigger phrases:**
- `check accessibility` — run full audit
- `fix accessibility` — auto-fix common issues
- `add accessibility badge` — add WCAG 2.2 AA badge to footer

**⚖️ Why this matters:** Non-accessible websites can result in lawsuits. Over 4,600 ADA web accessibility lawsuits were filed in 2023 alone.

---

## Updating progress.txt

After each task, append:

```
## [DATE] - [Brief Description]

### What was done
- Changes made

### Learnings
- Patterns discovered
- Gotchas to avoid

### Files modified
- path/to/files
```

**Important:** progress.txt is append-only. Never delete entries.

---

**Full documentation:** [ArchonDev.io](https://archondev.io)

**Full CLI:** `npm install -g archondev`

*Powered by ArchonDev - AI Development Governance by Jumping Ahead Corp.*
