# ArchonDev - OpenAI Codex Edition

**Make AI respect your codebase.**

---

## Setup

1. Unzip this package into your project root
2. Open your project with Codex CLI
3. Start coding — Codex reads `AGENTS.md` automatically

Codex natively supports `AGENTS.md` files, making this the simplest integration.

---

## What's Included

| File | Purpose |
|------|---------|
| `ARCHITECTURE.md` | Your rules: boundaries, invariants, protected paths |
| `AGENTS.md` | Instructions Codex follows automatically |
| `.archon/config.yaml` | Optional configuration |

---

## How It Works

Codex automatically reads `AGENTS.md` from your project root. No extra configuration needed.

```bash
cd your-project
codex
```

Codex will:
- Read `AGENTS.md` and `ARCHITECTURE.md` before making changes
- Follow the Ralph Methodology (fresh context per iteration)
- Respect component boundaries and invariants
- Persist learnings to `progress.txt`

---

## Customize

Edit `ARCHITECTURE.md` to define:
- **Components** — What parts of your codebase exist and how they connect
- **Invariants** — Rules AI must never violate (e.g., "no console.log in production")
- **Protected paths** — Files AI must ask before modifying

---

## Codex-Specific Tips

### Override Behavior
Add `AGENTS.override.md` in any directory to override rules for that subtree.

### Review Mode
Type `/review` in Codex to trigger code review mode (matches our AGENTS.md instructions).

### Web Search
Enable `--search` flag to let Codex look up documentation when needed.

---

## Full CLI (Optional)

For automated quality gates and AI-powered planning:

```bash
npm install -g archon
archon init
```

---

**Learn more:** [ArchonDev.io](https://ArchonDev.io)
