# New Project Interview Guide
**Powered by ArchonDev - AI Development Governance**

---

## When to Use This

This guide is for when a user starts with an **empty project folder**. The AI should conduct a friendly interview to understand what they want to build, then generate the appropriate ARCHITECTURE.md and project structure.

---

## The Interview Flow

### Opening Message

> 🎉 **Starting a new project? Great!**
>
> I'll ask you a few quick questions to set things up right. Answer as much or as little as you want — you can always refine later.
>
> Ready? Just say "let's go" or describe what you're building.

---

### Phase 1: The Vision (2-3 questions)

**Q1: What are you building?**
> In one sentence, what does this project do?
> 
> Examples: "A CLI tool for managing todo lists" or "A web app for tracking expenses"

**Q2: Who is it for?**
> Is this for yourself, your team, or end users?
> 
> (This helps me understand complexity and polish level)

**Q3: What's your experience level with this tech stack?**
> - 🟢 Expert — I know this well
> - 🟡 Intermediate — I've done similar work
> - 🔴 Learning — This is new to me
>
> (This helps me calibrate explanations)

---

### Phase 2: Tech Stack (2-3 questions)

**Q4: What language/framework?**
> - TypeScript / JavaScript
> - Python
> - Go
> - Rust
> - Other: [specify]
>
> Or say "help me choose" and I'll recommend based on your project

**Q5: Frontend, backend, or both?**
> - Frontend only (web UI)
> - Backend only (API, CLI, service)
> - Full-stack (both)
> - Library/package (consumed by other code)

**Q6: Any required integrations?**
> - Database (which one?)
> - External APIs
> - Authentication
> - None yet

---

### Phase 3: Quick Preferences (optional, can skip)

**Q7: Testing preference?**
> - Full TDD — tests before code
> - Tests for critical paths only
> - Minimal testing
> - Help me decide

**Q8: Anything AI should NEVER do in this project?**
> Examples: "Don't modify package.json without asking" or "Never use any npm packages"
>
> These become protected paths or invariants.

---

## Escape Hatches

Users can exit the interview at any time:

- **"Just start"** — Generate minimal ARCHITECTURE.md, begin coding
- **"Skip"** — Move to next question
- **"Later"** — Save progress, continue interview another time
- **"Show me what you have"** — Display generated config so far

---

## After the Interview

1. **Generate ARCHITECTURE.md** with:
   - Components based on their tech stack
   - Invariants based on their preferences (Q8)
   - Appropriate quality gates for their experience level

2. **Create folder structure** if agreed:
   ```
   src/
   tests/
   docs/
   .archon/
   ```

3. **Record in progress.txt**:
   ```
   ## [DATE] - Project Initialized
   
   ### Vision
   [Their answer to Q1]
   
   ### Stack
   - Language: [Q4]
   - Type: [Q5]
   - Integrations: [Q6]
   
   ### Preferences
   - Testing: [Q7]
   - Protected: [Q8]
   ```

4. **Prompt for first task**:
   > ✅ Project set up! What would you like to build first?

---

## Example Generated ARCHITECTURE.md

For a user who said: "TypeScript CLI tool, backend only, PostgreSQL, I'm intermediate"

```yaml
---
version: "1.0"
profile: "balanced"

systemGoals:
  - id: "GOAL-001"
    title: "Build a reliable CLI tool"
    priority: "HIGH"

components:
  - id: "cli"
    name: "CLI Commands"
    paths: ["src/cli/**"]
    boundary: "PUBLIC_API"
    
  - id: "core"
    name: "Business Logic"
    paths: ["src/core/**"]
    boundary: "INTERNAL"
    
  - id: "db"
    name: "Database"
    paths: ["src/db/**"]
    boundary: "INFRASTRUCTURE"

invariants:
  - id: "INV-001"
    severity: "BLOCKING"
    rule: "CLI must not import database directly"
    scope: "cli"

protectedPaths:
  - pattern: "src/db/schema.*"
    level: "HARD"
    reason: "Schema changes need migration"
---
```

---

*This file is for AI reference. Keep it in archondev-scenarios/ so it doesn't bloat the main AGENTS.md.*
