# Adapting ArchonDev to an Existing Project
**Powered by ArchonDev - AI Development Governance**

---

## When to Use This

This guide is for when a user drops ArchonDev files into an **existing project** that wasn't created with ArchonDev. The AI should offer to analyze the codebase and adapt the governance files to match.

---

## Detection

Trigger this scenario when:
- `ARCHITECTURE.md` exists (from the lite package)
- `progress.txt` is empty or missing
- Other source files exist (src/, package.json, main.py, etc.)

---

## Opening Message

> 👋 **I see you've added ArchonDev to an existing project!**
>
> I can analyze your codebase and adapt the governance files to match your structure. This helps me understand your architecture without changing any code.
>
> Would you like me to:
>
> **1. Analyze and adapt** — I'll scan your project and update ARCHITECTURE.md to match
>
> **2. Code review first** — I'll review your code for issues before setting up governance
>
> **3. Manual setup** — Keep the template files, I'll help you customize manually
>
> **4. Just start working** — Skip setup, use the defaults

---

## Analysis Plan (Option 1)

If user chooses "Analyze and adapt":

### Step 1: Project Discovery

> 📊 **Analyzing your project...**

Scan for:
- `package.json` / `Cargo.toml` / `pyproject.toml` / `go.mod` — tech stack
- `src/` structure — component organization
- Existing tests — testing patterns
- Config files — quality gate commands
- `README.md` — project purpose

### Step 2: Present Findings

> **Here's what I found:**
>
> **Tech Stack:** TypeScript with Node.js
> **Structure:** 
> - `src/api/` — API endpoints
> - `src/services/` — Business logic
> - `src/db/` — Database access
> 
> **Testing:** Jest with 42 test files
> **Build:** `npm run build`
>
> **Proposed Components:**
> | Component | Paths | Boundary |
> |-----------|-------|----------|
> | API | src/api/** | PUBLIC_API |
> | Services | src/services/** | INTERNAL |
> | Database | src/db/** | INFRASTRUCTURE |
>
> Does this look right? I can adjust before updating ARCHITECTURE.md.

### Step 3: Generate Adapted Files

After user confirms:

1. **Update ARCHITECTURE.md** with discovered components
2. **Update .archon/config.yaml** with actual commands
3. **Create DEPENDENCIES.md** with obvious dependencies
4. **Record in progress.txt**:
   ```
   ## [DATE] - ArchonDev Adapted to Existing Project
   
   ### Project Analysis
   - Tech: [discovered stack]
   - Components: [list]
   - Tests: [pattern]
   
   ### Governance Files Updated
   - ARCHITECTURE.md - Customized to match project structure
   - .archon/config.yaml - Build commands configured
   - DEPENDENCIES.md - Initial rules added
   ```

### Step 4: Confirm and Continue

> ✅ **Governance files adapted!**
>
> I've updated:
> - `ARCHITECTURE.md` — Matches your project structure
> - `.archon/config.yaml` — Uses your actual build commands
>
> What would you like to work on?

---

## Code Review First (Option 2)

If user wants a review before governance:

> 🔍 **Starting code review...**
>
> I'll analyze your code for:
> - Security issues
> - Potential bugs
> - Architecture patterns
> - Documentation gaps
>
> This is non-destructive — I won't change any files.

Then follow the Code Review Mode in AGENTS.md.

After review, offer to continue with Option 1.

---

## Manual Setup (Option 3)

If user prefers manual:

> 📝 **Manual Setup Mode**
>
> The template files are in place. Here's what to customize:
>
> **1. ARCHITECTURE.md**
> - Update `components` to match your folders
> - Add invariants for your coding standards
> - Set protected paths for critical files
>
> **2. .archon/config.yaml**
> - Change build/test/lint commands
> - Adjust quality gates per environment
>
> **3. AGENTS.md**
> - Add project-specific patterns
> - Document common commands
>
> Would you like help with any of these?

---

## Skip Setup (Option 4)

If user wants to start immediately:

> ⚡ **Using defaults — let's go!**
>
> I'll use the template governance rules. You can customize later by saying "archon adapt" or editing ARCHITECTURE.md directly.
>
> What would you like to work on?

Record choice in progress.txt for future reference.

---

## Trigger Phrases

- **"archon adapt"** — Restart the adaptation flow
- **"analyze my project"** — Run project discovery
- **"customize governance"** — Go to manual setup

---

*This file is for AI reference. Keep it in archondev-scenarios/ so it doesn't bloat the main AGENTS.md.*
