# ArchonDev - Google Gemini Edition

**Make AI respect your codebase.**

---

## Setup

1. Unzip this package into your project root
2. Open your project in your IDE with Gemini Code Assist
3. Tell Gemini: **"Read ARCHITECTURE.md"**
4. Start coding with governance

---

## What's Included

| File | Purpose |
|------|---------|
| `GEMINI.md` | Instructions Gemini reads on request |
| `ARCHITECTURE.md` | Your rules: boundaries, invariants, protected paths |
| `AGENTS.md` | AI assistant instructions (lean version) |
| `DEPENDENCIES.md` | File-level dependency tracking |
| `archondev-scenarios/` | Detailed prompts for new/existing/continuing projects |
| `.archon/config.yaml` | Optional configuration |

---

## Three Scenarios

ArchonDev adapts to your situation:

| Scenario | What Happens |
|----------|--------------|
| **New project** (empty folder) | Interview to define what you're building |
| **Existing project** | Offer to analyze and adapt governance to your code |
| **Continuing work** | Pick up where you left off |

---

## Customize

Edit `ARCHITECTURE.md` to define:
- **Components** - What parts of your codebase exist and how they connect
- **Invariants** - Rules AI must never violate (e.g., "no console.log in production")
- **Protected paths** - Files AI must ask before modifying

---

## Commands

Tell Gemini these phrases:

| Command | Action |
|---------|--------|
| `archon walkthrough` | Restart the onboarding flow |
| `archon adapt` | Analyze existing code and adapt governance |
| `archon status` | Show project summary |
| `review this file` | Code review mode (no modifications) |
| `memory check` | Check AI context usage |

---

## Full CLI (Optional)

For automated quality gates and AI-powered planning:

```bash
npm install -g archondev
archon init
```

---

**Learn more:** [ArchonDev.io](https://ArchonDev.io)

*Powered by ArchonDev - AI Development Governance by Jumping Ahead Corp.*
