# Pre-Deploy Accessibility Check Protocol

When user indicates they want to **deploy**, **go live**, **publish**, or **launch** a website or web application, this protocol activates automatically.

---

## When to Activate

Trigger phrases:
- "deploy to production"
- "go live"
- "publish the site"
- "launch the website"
- "push to staging/production"
- "make this public"

---

## The Protocol

### Step 1: Announce the Check

```
⚠️ **Pre-Deploy Accessibility Check**

Before deploying a live website, I need to verify WCAG 2.2 AA compliance.
This protects you from potential legal liability (ADA, EAA, Section 508).

Running accessibility audit...
```

### Step 2: Run the Checklist

Check each category and note issues:

#### Color Contrast (WCAG 1.4.3, 1.4.11)
- [ ] Normal text: 4.5:1 contrast ratio minimum
- [ ] Large text (18px+ or 14px bold): 3:1 minimum
- [ ] UI components and graphics: 3:1 minimum
- [ ] No information conveyed by color alone

#### Keyboard Navigation (WCAG 2.1.1, 2.1.2, 2.4.7)
- [ ] All interactive elements focusable via Tab
- [ ] Visible focus indicators on all elements
- [ ] No keyboard traps
- [ ] Skip link to main content

#### Images & Media (WCAG 1.1.1, 1.2.1-1.2.5)
- [ ] All images have alt text (or alt="" for decorative)
- [ ] Videos have captions
- [ ] Audio has transcripts

#### Forms (WCAG 1.3.1, 3.3.1, 3.3.2, 4.1.2)
- [ ] All inputs have associated labels
- [ ] Required fields clearly indicated
- [ ] Error messages are descriptive
- [ ] Form controls have accessible names

#### Structure (WCAG 1.3.1, 2.4.1, 2.4.6)
- [ ] Proper heading hierarchy (h1 → h2 → h3)
- [ ] Landmark regions (nav, main, footer)
- [ ] Descriptive page titles
- [ ] Language attribute on html element

#### Interactive Elements (WCAG 4.1.2, 2.5.3)
- [ ] Buttons have accessible names
- [ ] Links have descriptive text (not "click here")
- [ ] Custom components have ARIA roles/states
- [ ] Touch targets minimum 44x44px

### Step 3: Report Results

**If all checks pass:**
```
✅ **Accessibility Audit Passed**

Your site meets WCAG 2.2 AA requirements.

Proceeding with deployment...
```

**If issues found:**
```
⚠️ **Accessibility Issues Found**

| Issue | Location | WCAG | Severity |
|-------|----------|------|----------|
| [description] | [file:line] | [criterion] | [Critical/Major/Minor] |

---

⚖️ **Legal Notice**

Websites that don't meet accessibility standards may violate:
- **ADA** (Americans with Disabilities Act) — US
- **EAA** (European Accessibility Act) — EU, effective June 2025
- **Section 508** — US federal agencies and contractors
- **AODA** (Accessibility for Ontarians) — Ontario, Canada

Non-compliance can result in lawsuits, fines, and reputational damage.
In 2023, over 4,600 ADA web accessibility lawsuits were filed in the US alone.

---

**Options:**

1. **Fix issues now** (recommended)
   I'll propose fixes for each issue. Estimated time: [X minutes]

2. **Deploy anyway** (not recommended)
   You acknowledge the accessibility gaps and legal risks.

3. **Cancel deployment**
   Address issues in a future session.

Which would you like to do? (1/2/3)
```

### Step 4: Handle User Choice

**If user chooses 1 (Fix):**
- Generate fixes for each issue
- Apply fixes with user approval
- Re-run checklist to verify
- Proceed to deployment

**If user chooses 2 (Deploy anyway):**
```
⚠️ Acknowledged. Deploying without full accessibility compliance.

I've added a note to progress.txt about the pending accessibility issues.
Consider addressing these in a future session.

Proceeding with deployment...
```

**If user chooses 3 (Cancel):**
```
Deployment cancelled. 

The accessibility issues are saved in progress.txt.
Run "archon a11y check" or say "check accessibility" to review them again.
```

### Step 5: Add Accessibility Badge (if compliant)

When site passes all checks, offer to add the badge:

```
Would you like to add a "WCAG 2.2 AA Accessible" badge to your footer?
This signals your commitment to accessibility. (y/n)
```

If yes, add to footer template:
```html
<!-- WCAG 2.2 AA Compliance Badge -->
<div class="flex items-center gap-2 text-xs text-text-muted">
  <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
  </svg>
  <span>WCAG 2.2 AA Accessible</span>
</div>
```

---

## Quick Commands

| Command | Action |
|---------|--------|
| `check accessibility` | Run full audit |
| `fix accessibility` | Auto-fix common issues |
| `skip accessibility check` | Bypass for this deploy (not recommended) |
| `add accessibility badge` | Add footer badge manually |

---

## Common Auto-Fixes

The AI can automatically fix these issues:

| Issue | Auto-Fix |
|-------|----------|
| Low contrast text | Update to compliant color values |
| Missing alt text | Add descriptive alt based on context |
| Missing form labels | Add associated label elements |
| No skip link | Add skip-to-main link |
| No lang attribute | Add `lang="en"` to html |
| Missing focus styles | Add focus-visible CSS |

---

## Resources

- [WCAG 2.2 Quick Reference](https://www.w3.org/WAI/WCAG22/quickref/)
- [WebAIM Contrast Checker](https://webaim.org/resources/contrastchecker/)
- [axe DevTools](https://www.deque.com/axe/)
- [WAVE Evaluation Tool](https://wave.webaim.org/)

---

*This protocol helps protect you and your users. Accessibility is not optional—it's essential.*
