# Task Extraction Protocol

When user describes work involving **multiple items, changes, or steps**, use this protocol to ensure nothing gets missed.

---

## When to Activate

Trigger this protocol when the user's request contains:
- Multiple bullet points or numbered items
- Words like "and", "also", "plus", "as well as" connecting distinct tasks
- Requests spanning multiple files or components
- Any list of things to do, fix, add, or change

**Trigger phrases** (user can explicitly invoke):
- `plan these tasks` — force extraction mode
- `what's on my list` — show active tasks
- `task status` — show progress

---

## The Protocol

### Step 1: Extract & Number

Parse the user's request and create a numbered list:

```
I found these tasks in your request:

1. [ ] First task description
2. [ ] Second task description
3. [ ] Third task description

Is this list correct? Should I add or remove anything?
```

### Step 2: Get Confirmation

Wait for user to confirm the list is complete and accurate. Do not proceed until confirmed.

### Step 3: Lock the List

Save the confirmed list to `.archon/current-tasks.md`:

```markdown
# Current Task List

Created: [DATE]
Status: In Progress

## Tasks

1. [ ] First task description
2. [ ] Second task description
3. [ ] Third task description

## Progress Log

- [TIMESTAMP] List created and confirmed
```

### Step 4: Work Systematically

- Complete tasks in order (unless dependencies require different sequencing)
- After completing each task, update the file:
  - Change `[ ]` to `[x]`
  - Add entry to Progress Log
- Announce completion: "✓ Completed task 1: [description]. Moving to task 2."

### Step 5: Final Verification

Before declaring done:
1. Review all tasks are marked complete
2. Run any required quality gates
3. Present final summary:

```
All tasks complete:

1. [x] First task — done
2. [x] Second task — done  
3. [x] Third task — done

Quality gates: ✓ Build passed | ✓ Tests passed
```

---

## Commands

| Command | Action |
|---------|--------|
| `plan these tasks` | Force task extraction from current request |
| `what's on my list` | Display current task list with status |
| `task status` | Show progress (X of Y complete) |
| `skip task N` | Mark task N as skipped (with reason) |
| `add task: [desc]` | Add new task to current list |

---

## Why This Matters

Without explicit task tracking:
- Items get forgotten mid-session
- "Done" gets declared before all items are addressed
- Context window fills before completing the list
- No audit trail of what was actually completed

This protocol ensures every item is tracked, completed, and verified.
