# ArchonDev Governance Rules for GitHub Copilot
# Powered by ArchonDev - ArchonDev.io

## Core Methodology

You are operating under the **ArchonDev** development governance system. Follow these principles:

### The Golden Rule
> **Architecture is the input. Code is the output.**
> ARCHITECTURE.md defines what you CAN and CANNOT do. Code never dictates architecture.

### Ralph Protocol (Fresh Context)
1. **Start clean** - Each session begins with fresh context
2. **Read first** - Load ARCHITECTURE.md and AGENTS.md before writing code
3. **Check history** - Review progress.txt for past learnings
4. **Atomic changes** - Complete one focused task per iteration
5. **Persist learnings** - Append insights to progress.txt before finishing

---

## Before Writing Code

1. **Parse ARCHITECTURE.md** - Read the YAML frontmatter for:
   - `components` - Understand system structure
   - `invariants` - Rules you MUST NOT violate
   - `protectedPaths` - Files requiring approval
   - `environments` - Quality gates to satisfy

2. **Check Component Boundaries**
   - Identify which component you're modifying
   - Respect `dependsOn` relationships
   - Honor coupling constraints (TIGHT vs LOOSE)

3. **Verify Invariants**
   - BLOCKING invariants = Do not write violating code
   - WARN invariants = Proceed with caution, document tradeoffs

---

## During Implementation

### Respect Boundaries
```typescript
// ❌ WRONG: Violating LOOSE coupling
import { internalHelper } from '../core/internal/helper';

// ✅ CORRECT: Using public interface
import { publicApi } from '../core';
```

### Honor Invariants
- Never log secrets (SEC-001)
- Use proper abstractions per component boundaries
- Follow patterns established in AGENTS.md

### Protected Paths
Before modifying files matching `protectedPaths` patterns:
- Ask for explicit approval
- Explain why the change is necessary
- Consider alternatives

---

## After Completion

1. **Run Quality Checks**
   ```bash
   npm run build      # Syntax check
   npm run test       # Unit tests
   npm run lint       # Linting
   ```

2. **Update progress.txt**
   ```
   ## [DATE] - [Brief Description]
   ### What was done
   - Changes made
   ### Learnings
   - Patterns discovered
   - Gotchas to avoid
   ### Files modified
   - path/to/files
   ```

3. **Commit Message Format**
   ```
   feat|fix|docs: [description]
   ```

---

## Key Files

| File | Purpose |
|------|---------|
| `ARCHITECTURE.md` | Governance constitution (source of truth) |
| `AGENTS.md` | AI assistant instructions and patterns |
| `progress.txt` | Append-only learnings log |
| `.archon/config.yaml` | Environment configuration |

---

## Learn More

- **Documentation:** https://ArchonDev.io
- **Full CLI:** `npm install -g archondev`

---

*Powered by ArchonDev - AI Development Governance by Jumping Ahead Corp.*
