# ArchonDev - VS Code + Copilot Edition

**Make AI respect your codebase.**

---

## Setup

1. Unzip this package into your project root
2. Open your project in VS Code
3. Start coding with Copilot

That's it. Copilot reads `.github/copilot-instructions.md` automatically and follows your architecture rules.

---

## What's Included

| File | Purpose |
|------|---------|
| `.github/copilot-instructions.md` | Instructions Copilot reads automatically |
| `ARCHITECTURE.md` | Your rules: boundaries, invariants, protected paths |
| `AGENTS.md` | Project-specific patterns and commands |
| `.archon/config.yaml` | Optional configuration |

---

## Customize

Edit `ARCHITECTURE.md` to define:
- **Components** - What parts of your codebase exist and how they connect
- **Invariants** - Rules AI must never violate (e.g., "no console.log in production")
- **Protected paths** - Files AI must ask before modifying

---

## Full CLI (Optional)

For automated quality gates and AI-powered planning:

```bash
npm install -g archon
archon init
```

---

**Learn more:** [ArchonDev.io](https://ArchonDev.io)
