# Continuing an Existing ArchonDev Session
**Powered by ArchonDev - AI Development Governance**

---

## When to Use This

This guide is for when a user returns to a project that **already has ArchonDev set up**. The AI should pick up where they left off and ask what they want to do next.

---

## Detection

Trigger this scenario when:
- `ARCHITECTURE.md` exists
- `progress.txt` has previous entries
- This is clearly a continuation, not first-time setup

---

## Opening Behavior

### Step 1: Quick Context Load

Silently read:
1. `ARCHITECTURE.md` — Current governance rules
2. `progress.txt` — Last 2-3 entries for context
3. `DEPENDENCIES.md` — Active dependency rules

### Step 2: Check for Handoff

Look for a recent "Context Handoff" entry in progress.txt:

```
## Context Handoff - [TIMESTAMP]
### Next Steps for Fresh Session
1. [First task]
2. [Second task]
```

If found, prioritize those next steps.

---

## Opening Message

### If Handoff Exists

> 👋 **Welcome back!**
>
> I found a handoff from your last session:
>
> **Previous task:** [from handoff]
> **Next steps:**
> 1. [step 1]
> 2. [step 2]
>
> Ready to continue, or would you like to do something else?

### If No Handoff (Normal Return)

> 👋 **Welcome back!**
>
> **Last activity:** [brief summary from progress.txt]
>
> What would you like to work on?
>
> Quick options:
> - **"continue"** — Pick up where we left off
> - **"review [file]"** — Code review mode
> - **"new feature"** — Plan something new
> - **"status"** — Show project summary

---

## Quick Commands

### Status Command

When user says "status", "archon status", or "what's happening":

> 📊 **Project Status**
>
> **Components:** [count from ARCHITECTURE.md]
> **Invariants:** [count] ([blocking count] blocking)
> **Recent changes:** [from progress.txt]
>
> **Quality gates for development:**
> - [ ] Syntax: `npm run build`
> - [ ] Tests: `npm run test`
>
> What would you like to focus on?

### Continue Command

When user says "continue":

Read last progress.txt entry and offer to:
1. Continue the same type of work
2. Move to the next logical step
3. Address any noted blockers

### Memory Check

When returning after a long break:

> ℹ️ **Note:** My context is fresh — I don't remember our previous conversation, but I've read your progress.txt and ARCHITECTURE.md.
>
> If anything's unclear, just point me to the relevant file.

---

## Ongoing Session Behavior

Once working, follow standard ArchonDev practices:

1. **Check DEPENDENCIES.md** before modifying files
2. **Respect invariants** from ARCHITECTURE.md
3. **Update progress.txt** after completing work
4. **Monitor context** and suggest handoff if needed

---

## End of Session

When user is done or context is getting full:

> 💾 **Before we wrap up:**
>
> Should I save a handoff for next time?
>
> - **"yes"** — I'll record current task and next steps
> - **"no"** — Just update progress.txt normally
> - **"done"** — Mark current task complete, no handoff needed

---

## Trigger Phrases

- **"archon status"** — Show project summary
- **"continue"** — Resume previous work
- **"what were we doing"** — Show last session context
- **"save handoff"** — Create handoff entry for next session

---

*This file is for AI reference. Keep it in archondev-scenarios/ so it doesn't bloat the main AGENTS.md.*
