---
version: "1.0"
updatedAt: "2026-01-22"
rules: []
---

# Dependencies (File & Symbol Impact Map)

## What is this file?

DEPENDENCIES.md tracks **file-level dependencies** to prevent regressions. When you change a `source` file, you must review and potentially update each `dependent`.

This is your "what-breaks-what" map — the most valuable asset for preventing regressions.

---

## How to use

### For AI Assistants

**Before modifying any file:**
1. Check if the file appears as a `source` in any rule below
2. If yes, review the `dependents` list
3. Ensure your changes don't break dependent files
4. Run any `mustTest` commands before committing

**When discovering new dependencies:**
- Add a new rule to this file
- Document the reason for the dependency
- Keep rules high-signal (don't track every import)

### For Humans

- Run `archon deps check --files <changed-files>` before commits
- Run `archon deps graph` to visualize dependencies
- Add rules with `archon deps add --source <path> --dependent <path>`

---

## Example Rule

```yaml
rules:
  - id: "DEP-001"
    source: "src/api/auth.ts"
    dependents:
      - "src/cli/**"
      - "src/server/routes.ts"
    severity: "WARNING"
    reason: "CLI and server depend on auth types; changes may require updates"
    mustTest:
      - "npm test auth"
```

---

## Severity Levels

| Level | Meaning |
|-------|---------|
| **INFO** | FYI — might want to review dependents |
| **WARNING** | Should review dependents before merging |
| **BLOCKER** | Must update dependents before this change can proceed |

---

## Your Dependency Rules

<!-- Add your first rule by editing the YAML frontmatter above, or use: -->
<!-- archon deps add --source <path> --dependent <path> -->

*No rules defined yet. Start by identifying your most critical file dependencies.*

---

*Powered by [ArchonDev](https://archondev.io) — AI Development Governance*
